-- Universal Suffrage
-- Author: Machiavelli
-- DateCreated: 5/11/2013 12:24:53 PM
--------------------------------------------------------------
function AddAllCultureBonusToAllCities(playerID, policyTypeID)
	local player = Players[playerID];
	local universalSuffrageID = GameInfoTypes["POLICY_UNIVERSAL_SUFFRAGE"];
	local birthplaceID = GameInfoTypes["BUILDING_GREAT_ARTIST"];

	if(player:HasPolicy(universalSuffrageID) and not player:IsPolicyBlocked(universalSuffrageID)) then
		for city in player:Cities() do
			if(city:IsHasBuilding(birthplaceID)) then
				city:SetNumRealBuilding(GameInfoTypes["BUILDING_GREAT_ARTIST_BONUS_CULTURE"], 1);
			end
		end
	end
end
GameEvents.PlayerAdoptPolicy.Add(AddAllCultureBonusToAllCities);
GameEvents.PlayerAdoptPolicyBranch.Add(AddAllCultureBonusToAllCities);

function DisableBlockedUniversalSuffrage(playerID)
	local player = Players[playerID];
	local universalSuffrageID = GameInfoTypes["POLICY_UNIVERSAL_SUFFRAGE"];

	if(player:HasPolicy(universalSuffrageID) and player:IsPolicyBlocked(universalSuffrageID)) then
		for city in player:Cities() do
			city:SetNumRealBuilding(GameInfoTypes["BUILDING_GREAT_ARTIST_BONUS_CULTURE"], 0);
		end
	end
end
GameEvents.PlayerDoTurn.Add(DisableBlockedUniversalSuffrage);